% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{is_acyclic}
\alias{is_acyclic}
\title{Acyclic graphs}
\usage{
is_acyclic(graph)
}
\arguments{
\item{graph}{The input graph.}
}
\value{
A logical vector of length one.
}
\description{
This function tests whether the given graph is free of cycles.
}
\details{
This function looks for directed cycles in directed graphs and undirected
cycles in undirected graphs.
}
\examples{

g <- make_graph(c(1,2, 1,3, 2,4, 3,4), directed = TRUE)
is_acyclic(g)
is_acyclic(as_undirected(g))
}
\seealso{
\code{\link[=is_forest]{is_forest()}} and \code{\link[=is_dag]{is_dag()}} for functions specific to undirected
and directed graphs.

Graph cycles
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{has_eulerian_path}()},
\code{\link{is_dag}()}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\concept{cycles}
\concept{structural.properties}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/latest/igraph-Structural.html#igraph_is_acyclic}{\code{igraph_is_acyclic()}}.}

